#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.profile.interfaces import IAdminProfile
from pyams_form.interfaces.form import IInnerTabForm
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_security.zmi.profile import UserProfileEditForm
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from pyramid.view import view_config
from z3c.form import field
from zope.interface import Interface

from pyams_content import _


@adapter_config(name='admin_profile',
                context=(Interface, IPyAMSLayer, UserProfileEditForm),
                provides=IInnerTabForm)
class AdminProfileTabForm(InnerAdminEditForm):
    """Admin profile tab form"""

    prefix = 'admin_profile.'

    tab_label = _("Admin. profile")
    legend = None

    fields = field.Fields(IAdminProfile).omit('favorites')
    edit_permission = None

    label_css_class = 'control-label col-md-4'
    input_css_class = 'col-md-8'

    weight = 20

    def getContent(self):
        return IAdminProfile(self.request.principal)


@view_config(name='switch-user-favorite.json', context=Interface, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
def switch_favorite(request):
    """Add or remove reference from user favorites"""
    profile = IAdminProfile(request.principal)
    favorites = profile.favorites or []
    oid = request.params.get('oid')
    if oid:
        if oid in favorites:
            favorites.remove(oid)
        else:
            favorites.append(oid)
        profile.favorites = favorites
        return {'oid': oid,
                'favorite': oid in favorites}
