#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import re

from pyramid.tweens import MAIN

from pyams_content.shared.alert.api import REST_ALERT_TYPE_GETTER_ROUTE
from pyams_content.shared.alert.api.interfaces import REST_ALERT_TYPE_GETTER_ROUTE_SETTING, \
    REST_ALERT_TYPE_GETTER_ROUTE_DEFAULT
from pyams_content.shared.common.api.interfaces import REST_CONTENT_PUBLIC_GETTER_ROUTE, \
    REST_CONTENT_PUBLIC_GETTER_ROUTE_DEFAULT, REST_CONTENT_PUBLIC_GETTER_ROUTE_SETTING, \
    REST_CONTENT_PUBLIC_SEARCH_ROUTE, REST_CONTENT_PUBLIC_SEARCH_ROUTE_DEFAULT, \
    REST_CONTENT_PUBLIC_SEARCH_ROUTE_SETTING, REST_DATATYPES_PUBLIC_GETTER_ROUTE, \
    REST_DATATYPES_PUBLIC_GETTER_ROUTE_DEFAULT, REST_DATATYPES_PUBLIC_GETTER_ROUTE_SETTING


def include_package(config):
    """Pyramid include"""

    # add translations
    config.add_translation_dirs('pyams_content:locales')

    # add custom tween
    config.add_tween('pyams_content.features.redirect.tween.redirect_tween_factory', over=MAIN)

    # add API routes
    config.add_route(REST_ALERT_TYPE_GETTER_ROUTE,
                     config.registry.settings.get(REST_ALERT_TYPE_GETTER_ROUTE_SETTING,
                                                  REST_ALERT_TYPE_GETTER_ROUTE_DEFAULT))

    config.add_route(REST_DATATYPES_PUBLIC_GETTER_ROUTE,
                     config.registry.settings.get(REST_DATATYPES_PUBLIC_GETTER_ROUTE_SETTING,
                                                  REST_DATATYPES_PUBLIC_GETTER_ROUTE_DEFAULT))

    config.add_route(REST_CONTENT_PUBLIC_SEARCH_ROUTE,
                     config.registry.settings.get(REST_CONTENT_PUBLIC_SEARCH_ROUTE_SETTING,
                                                  REST_CONTENT_PUBLIC_SEARCH_ROUTE_DEFAULT))
    config.add_route(REST_CONTENT_PUBLIC_GETTER_ROUTE,
                     config.registry.settings.get(REST_CONTENT_PUBLIC_GETTER_ROUTE_SETTING,
                                                  REST_CONTENT_PUBLIC_GETTER_ROUTE_DEFAULT))

    # load registry components
    try:
        import pyams_zmi
    except ImportError:
        config.scan(ignore=[re.compile('zmi').search])
    else:
        config.scan()

    if hasattr(config, 'load_zcml'):
        config.load_zcml('configure.zcml')
