#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation.interfaces import IAnnotations

from pyams_content.features.alert.interfaces import ALERT_CONTAINER_KEY
from pyams_content.shared.common import IWfSharedContent
from pyams_content.shared.common.interfaces import ISharedTool
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, set_local_registry


def evolve(site):
    """Evolve 6: rename resource annotations"""
    registry = get_local_registry()
    try:
        local_registry = site.getSiteManager()
        set_local_registry(local_registry)
        print("Removing alerts annotations: ", end="")
        for content in find_objects_providing(site, IWfSharedContent):
            annotations = IAnnotations(content, None)
            if annotations is None:
                continue
            if 'pyams_content.alerts' in annotations:
                print(".", sep="", end="")
                del annotations['pyams_content.alerts']
        print("")
    finally:
        set_local_registry(registry)
