#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation.interfaces import IAnnotations

from pyams_content.features.alert.interfaces import ALERT_CONTAINER_KEY
from pyams_content.shared.common.interfaces import ISharedTool
from pyams_utils.registry import get_local_registry, set_local_registry


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        local_registry = site.getSiteManager()
        set_local_registry(local_registry)
        for tool in local_registry.getAllUtilitiesRegisteredFor(ISharedTool):
            local_registry.registerUtility(tool, ISharedTool, name=tool.shared_content_type)
    finally:
        set_local_registry(registry)
