#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation.interfaces import IAnnotations

from pyams_content.features.alert.interfaces import ALERT_CONTAINER_KEY
from pyams_utils.registry import get_local_registry, set_local_registry


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        annotations = IAnnotations(site)
        if ALERT_CONTAINER_KEY in annotations:
            del annotations[ALERT_CONTAINER_KEY]
    finally:
        set_local_registry(registry)
