#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from hypatia.interfaces import ICatalog

from pyams_catalog.utils import reindex_object
from pyams_i18n.interfaces import II18n
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, get_utility, set_local_registry
from pyams_utils.timezone import gmtime
from pyams_workflow.interfaces import IWorkflow, IWorkflowPublicationInfo, \
    IWorkflowPublicationSupport, IWorkflowState, IWorkflowVersions


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        catalog = get_utility(ICatalog)
        for content in find_objects_providing(site, IWorkflowPublicationSupport):
            info = IWorkflowPublicationInfo(content, None)
            if info is None:
                continue
            print("Updating workflow for content « {} »".format(
                II18n(content).query_attribute('title')))
            workflow = IWorkflow(content)
            versions = IWorkflowVersions(content, None)
            if versions is None:
                info._first_content_publication_date = info.first_publication_date
            else:
                for version in versions.get_versions():
                    state = IWorkflowState(version)
                    pub_date = state.get_first_state_date(workflow.published_states)
                    if pub_date is not None:
                        info._first_content_publication_date = gmtime(pub_date)
                        break
            reindex_object(content, catalog)
    finally:
        set_local_registry(registry)
