#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation import IAnnotations

from pyams_content.component.theme import COLLECTIONS_MANAGER_KEY, ICollectionsManager, \
    ITagsManager
from pyams_content.features.search.interfaces import ISearchManagerInfo
from pyams_content.shared.resource.interfaces import IResourceManager
from pyams_utils.registry import get_local_registry, query_utility, set_local_registry

__docformat__ = 'restructuredtext'


def evolve(site):
    """Evolve 3: update search settings"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        # tags search updates
        tags_info = ITagsManager(site)
        search_info = ISearchManagerInfo(site)
        if getattr(tags_info, 'enable_tags_search', None) is not None:
            print("Updating tags search settings...")
            search_info.enable_tags_search = tags_info.enable_tags_search
            search_info.tags_search_target = tags_info.tags_search_target
            del tags_info.tags_search_target
            del tags_info.enable_tags_search
        # collections settings updates from resources settings
        resources = query_utility(IResourceManager)
        if resources is not None:
            annotations = IAnnotations(resources)
            res_collections_info = annotations.get(COLLECTIONS_MANAGER_KEY)
            if res_collections_info is not None:
                print("Updating collections settings...")
                root_collections_info = ICollectionsManager(site)
                if getattr(res_collections_info, 'thesaurus_name', None) is not None:
                    root_collections_info.thesaurus_name = res_collections_info.thesaurus_name
                    root_collections_info.extract_name = getattr(res_collections_info,
                                                                 'extract_name', None)
                del annotations[COLLECTIONS_MANAGER_KEY]
    finally:
        set_local_registry(registry)
