#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Bool

from pyams_portal.interfaces import IPortletSettings

from pyams_content import _


class IToolboxPortletSettings(IPortletSettings):
    """Toolbox portlet settings"""

    allow_printing = Bool(title=_("Allow printing?"),
                          description=_("If 'no', printing will be disabled"),
                          required=True,
                          default=True)

    allow_sharing = Bool(title=_("Allow sharing?"),
                         description=_("If 'no', sharing buttons won't be displayed"),
                         required=True,
                         default=True)
