#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.container.constraints import containers, contains
from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice, TextLine

from pyams_content import _
from pyams_content.interfaces.container import IOrderedContainer
from pyams_content.reference.pictograms.interfaces import SELECTED_PICTOGRAM_VOCABULARY
from pyams_i18n.schema import I18nTextLineField


SOCIAL_SHARE_INFO_KEY = 'pyams_content.social_share.info'
SOCIAL_SHARE_MANAGER_KEY = 'pyams_content.social_share'


class ISocialShareInfo(Interface):
    """General social share information interface"""

    twitter_account = TextLine(title=_("Twitter account"),
                               description=_("Name of Twitter account (including leading '@') to use for website "
                                             "attribution"),
                               required=False)

    twitter_creator_account = TextLine(title=_("Contents creator account"),
                                       description=_("You can use another Twitter account (including leading '@') "
                                                     "for contents attribution; if empty, general Twitter account "
                                                     "will be used"),
                                       required=False)

    fb_account = TextLine(title=_("Facebook account"),
                          description=_("Complete URL of Facebook account used for content attribution"),
                          required=False)

    fb_app_id = TextLine(title=_("Facebook AppID"),
                         description=_("ID of a Facebook App matching your web site"),
                         required=False)


class ISocialShareItem(Interface):
    """Social network share item interface"""

    containers('.ISocialShareManager')

    active = Bool(title=_("Active item?"),
                  description=_("If 'no', selected item is inactive"),
                  required=True,
                  default=True)

    label = I18nTextLineField(title=_("Label"),
                              description=_("This label will be associated to share link"),
                              required=True)

    target_url = I18nTextLineField(title=_("Content share URL"),
                                   description=_("URL used to share this content on given network; {url} string "
                                                 "will be replaced automatically by content canonical URL, "
                                                 "and {title} by content title (if required)"),
                                   required=True)

    def get_url(self, context, request):
        """Get canonical URL for given context and request"""

    pictogram_name = Choice(title=_("Pictogram"),
                            description=_("Name of pictogram associated with this social network"),
                            required=False,
                            vocabulary=SELECTED_PICTOGRAM_VOCABULARY)

    pictogram = Attribute("Selected pictogram object")


class ISocialShareManager(IOrderedContainer):
    """Social network share item container interface"""

    contains(ISocialShareItem)

    def append(self, value, notify=True):
        """Append given pictogram item to container"""

    def get_active_items(self):
        """Get list of visible pictogram items"""


class ISocialShareManagerTarget(Interface):
    """Content share manager target marker interface"""
