#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.features.search import ISearchFolder
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import NullAdapter
from pyams_utils.interfaces import FORBIDDEN_PERMISSION, VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


@viewlet_config(name='references.menu', context=ISearchFolder, layer=IAdminLayer,
                manager=IPropertiesMenu)
class SearchFolderReferencesMenu(NullAdapter):
    """Disabled search folder references menu"""


@pagelet_config(name='references.html', context=ISearchFolder, layer=IPyAMSLayer,
                permission=FORBIDDEN_PERMISSION)
@ajax_config(name='references.json', context=ISearchFolder, layer=IPyAMSLayer,
             permission=FORBIDDEN_PERMISSION)
class SearchFolderReferencesEditForm(NullAdapter):
    """Disabled search folder references settings edit form"""
