#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from pyams_content.features.search import ISearchFolder
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_content.shared.view.zmi.properties import ViewPropertiesEditForm
from pyams_form.form import ajax_config
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IInnerSubForm
from pyams_form.widget import HiddenSelect2FieldWidget
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.form import InnerAdminEditForm


__docformat__ = 'restructuredtext'

from pyams_content import _


@pagelet_config(name='properties.html', context=ISearchFolder, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=ISearchFolder, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderPropertiesEditForm(SharedContentPropertiesEditForm):
    """Search folder properties edit form"""

    def updateWidgets(self, prefix=None):
        # don't override base widgets update method
        super(SharedContentPropertiesEditForm, self).updateWidgets(prefix)


@adapter_config(name='view-settings',
                context=(ISearchFolder, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class SearchFolderSettingsEditSubform(ViewPropertiesEditForm):
    """Search folder settings edit sub-form extension"""

    legend = _("Main search settings")

    fields = field.Fields(ISearchFolder).select('selected_content_types', 'selected_datatypes',
                                                'excluded_content_types', 'excluded_datatypes',
                                                'order_by', 'reversed_order',
                                                'limit', 'age_limit')
    fields['selected_datatypes'].widgetFactory = HiddenSelect2FieldWidget
    fields['excluded_datatypes'].widgetFactory = HiddenSelect2FieldWidget


@adapter_config(name='navigation',
                context=(ISearchFolder, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class SearchFolderNavigationPropertiesEditForm(InnerAdminEditForm):
    """Search folder navigation properties edit form"""

    prefix = 'navigation_form.'

    css_class = 'form-group'
    padding_class = ''
    fieldset_class = 'bordered margin-top-10 padding-y-5'

    legend = None
    main_group_legend = _("Navigation properties")
    main_group_class = 'inner switcher no-y-padding'

    fields = field.Fields(ISearchFolder).select('visible_in_list', 'navigation_title')

    weight = 5

    def check_mode(self):
        if self.parent_form is not None:
            self.mode = self.parent_form.mode

    def updateGroups(self):
        self.add_group(NamedWidgetsGroup(self, 'navigation', self.widgets,
                                         ('visible_in_list', 'navigation_title'),
                                         fieldset_class=self.fieldset_class,
                                         legend=self.main_group_legend,
                                         css_class=self.main_group_class,
                                         switch=True,
                                         display_mode='always'))
        super(SearchFolderNavigationPropertiesEditForm, self).updateGroups()
