#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form.interfaces import INPUT_MODE
from z3c.form.widget import FieldWidget

from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_form.interfaces.form import IFormLayer
from pyams_form.widget import Select2Widget, widgettemplate_config


@widgettemplate_config(mode=INPUT_MODE, template='templates/renderer-input.pt', layer=IFormLayer)
class RendererWidget(Select2Widget):
    """Illustration renderer selection widget"""

    @property
    def show_renderer_properties(self):
        renderer = IContentRenderer(self.context, None)
        return (renderer is not None) and (renderer.settings_interface is not None)


def RendererFieldWidget(field, request):
    return FieldWidget(field, RendererWidget(request))
