#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.exceptions import NotFound
from pyramid.httpexceptions import HTTPNotFound

from pyams_content.features.redirect.interfaces import IRedirectionManager


def redirect_tween_factory(handler, registry):
    """Redirect tween factory

    This tween is used to handle NotFound errors: when a request which raises
    a NotFound error is served, we look info redirects configuration to check if
    given URL is matching any defined redirection, in which case another HTTPRedirect
    response is returned with a new location; another content using a proxy request
    can also be returned.
    """

    def redirect_tween(request):
        try:
            response = handler(request)
        except (NotFound, HTTPNotFound):
            manager = IRedirectionManager(request.root, None)
            if manager is not None:
                response = manager.get_response(request)
                if response is not None:
                    return response
            raise
        else:
            return response

    return redirect_tween
