#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content import _
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.component.links.interfaces import IInternalLink
from pyams_content.features.menu.portlet.navigation.interfaces.double import IDoubleNavigationMenusContainer, \
    IDoubleNavigationPortletSettings
from pyams_content.features.menu.zmi import IMenusView, MenusTable, MenusView
from pyams_form.form import AJAXEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_workflow.interfaces import IWorkflowPublicationInfo


@pagelet_config(name='properties.html', context=IDoubleNavigationPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class DoubleNavigationPortletSettingsEditor(PortletSettingsEditor):
    """Double navigation portlet settings editor"""

    settings = IDoubleNavigationPortletSettings


@adapter_config(name='properties.json', context=(IDoubleNavigationPortletSettings, IPyAMSLayer), provides=IPagelet)
class DoubleNavigationPortletSettingsAJAXEditor(AJAXEditForm, DoubleNavigationPortletSettingsEditor):
    """Double navigation portlet settings editor, JSON renderer"""


class DoubleNavigationPortletMenusTable(MenusTable):
    """Double navigation portlet menus table"""

    associations_name = 'menus'


@adapter_config(name='double-navigation-menus',
                context=(IDoubleNavigationPortletSettings, IPyAMSLayer, PortletSettingsPropertiesEditor),
                provides=IInnerSubForm)
@adapter_config(name='++ass++menus', context=(IDoubleNavigationMenusContainer, IPyAMSLayer), provides=IMenusView)
class DoubleNavigationPortletLinksView(MenusView):
    """Double navigation portlet menus view"""

    title = _("Navigation menus")

    table_class = DoubleNavigationPortletMenusTable
    weight = 10


@adapter_config(context=(Interface, IPyAMSLayer, Interface, IDoubleNavigationPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/double-preview.pt', layer=IPyAMSLayer)
class DoubleNavigationPortletPreviewer(PortletPreviewer):
    """Double navigation portlet previewer"""

    @classmethod
    def get_link_info(cls, link):
        return IAssociationInfo(link)

    @classmethod
    def get_link_status(cls, link):
        if not IInternalLink.providedBy(link):
            return True
        target = link.get_target()
        return (target is not None) and IWorkflowPublicationInfo(target).is_published()
