#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.interface import alsoProvides, implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import ASSOCIATION_CONTAINER_KEY
from pyams_content.component.illustration import IBasicIllustrationTarget
from pyams_content.features.menu.interfaces import IMenu, IMenuLinksContainer, IMenuLinksContainerTarget
from pyams_content.features.menu.portlet.navigation.interfaces.simple import ISimpleNavigationMenu, \
    ISimpleNavigationPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from pyams_content import _


SIMPLE_NAVIGATION_PORTLET_NAME = 'pyams_content.portlet.navigation.simple'
SIMPLE_NAVIGATION_LINKS_KEY = '{0}::links'.format(ASSOCIATION_CONTAINER_KEY)


@factory_config(provided=ISimpleNavigationPortletSettings)
@implementer(IMenuLinksContainerTarget)
class SimpleNavigationPortletSettings(PortletSettings):
    """Simple navigation portlet settings"""

    title = FieldProperty(ISimpleNavigationPortletSettings['title'])

    @property
    def links(self):
        return get_annotation_adapter(self, SIMPLE_NAVIGATION_LINKS_KEY, IMenu,
                                      markers=ISimpleNavigationMenu, name='++ass++links')


@adapter_config(name='links', context=ISimpleNavigationPortletSettings, provides=IMenuLinksContainer)
def simple_navigation_links_adapter(context):
    """Simple navigation links factory"""
    return context.links


@portlet_config(permission=VIEW_PERMISSION)
class SimpleNavigationPortlet(Portlet):
    """Simple navigation portlet"""

    name = SIMPLE_NAVIGATION_PORTLET_NAME
    label = _("Simple navigation")

    toolbar_css_class = 'fa fa-fw fa-2x fa-bars'

    settings_factory = ISimpleNavigationPortletSettings


@subscriber(IObjectAddedEvent, parent_selector=ISimpleNavigationMenu)
def handle_added_navigation_link(event):
    alsoProvides(event.object, IBasicIllustrationTarget)
