#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.interface import alsoProvides, implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import ASSOCIATION_CONTAINER_KEY
from pyams_content.component.illustration.interfaces import IBasicIllustrationTarget
from pyams_content.features.menu.interfaces import IMenusContainer, IMenusContainerTarget
from pyams_content.features.menu.portlet.navigation.interfaces.double import IDoubleNavigationMenu, \
    IDoubleNavigationMenusContainer, IDoubleNavigationPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from pyams_content import _


DOUBLE_NAVIGATION_PORTLET_NAME = 'pyams_content.portlet.navigation.double'
DOUBLE_NAVIGATION_LINKS_KEY = '{0}::menus'.format(ASSOCIATION_CONTAINER_KEY)


@factory_config(provided=IDoubleNavigationPortletSettings)
@implementer(IMenusContainerTarget)
class DoubleNavigationPortletSettings(PortletSettings):
    """Double navigation portlet settings"""

    title = FieldProperty(IDoubleNavigationPortletSettings['title'])

    @property
    def menus(self):
        return get_annotation_adapter(self, DOUBLE_NAVIGATION_LINKS_KEY, IMenusContainer,
                                      markers=IDoubleNavigationMenusContainer, name='++ass++menus')


@adapter_config(name='menus', context=IDoubleNavigationPortletSettings, provides=IMenusContainer)
def simple_navigation_links_adapter(context):
    """Double navigation menus factory"""
    return context.menus


@portlet_config(permission=VIEW_PERMISSION)
class DoubleNavigationPortlet(Portlet):
    """Double navigation portlet"""

    name = DOUBLE_NAVIGATION_PORTLET_NAME
    label = _("Double navigation")

    toolbar_css_class = 'fa fa-fw fa-2x fa-th-list'

    settings_factory = IDoubleNavigationPortletSettings


@subscriber(IObjectAddedEvent, parent_selector=IDoubleNavigationMenusContainer)
def handle_added_navigation_menu(event):
    """Add marker interface to added menus container"""
    alsoProvides(event.object, IDoubleNavigationMenu, IBasicIllustrationTarget)


@subscriber(IObjectAddedEvent, parent_selector=IDoubleNavigationMenu)
def handle_added_navigation_menu_link(event):
    """Add marker interface to added menu link"""
    alsoProvides(event.object, IBasicIllustrationTarget)
