#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation.interfaces import IAttributeAnnotatable
from zope.interface import Attribute
from zope.schema import Choice

from pyams_content.features.renderer import IContentRenderer, IRenderedContent, IRendererSettings
from pyams_utils.interfaces.inherit import IInheritInfo

from pyams_content import _


HEADER_SETTINGS_KEY = 'pyams_content.header'
HEADER_RENDERER_SETTINGS_KEY = 'pyams_content.header::{0}'

HEADER_RENDERERS = 'PyAMS.header.renderers'


class IHeaderSettings(IInheritInfo, IRenderedContent):
    """Header settings interface"""

    renderer = Choice(title=_("Header template"),
                      description=_("Presentation template used for this header"),
                      vocabulary=HEADER_RENDERERS,
                      required=False,
                      default='hidden')

    settings = Attribute("Renderer settings")


class IHeaderTarget(IAttributeAnnotatable):
    """Header target marker interface"""


class IHeaderRenderer(IContentRenderer):
    """Header renderer interface"""

    name = Attribute("Renderer name")
    settings_key = Attribute("Renderer settings key")
    cache_key = Attribute("Renderer cache key")


class IHeaderRendererSettings(IRendererSettings):
    """Header renderer settings interface"""

    can_apply_on_root = Attribute("Can apply header on root?")
