#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.component.interfaces import ISite

from pyams_content.features.glossary.task import GlossaryUpdaterTask
from pyams_form.form import ajax_config, AJAXAddForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_scheduler.zmi.scheduler import SchedulerTasksTable
from pyams_scheduler.zmi.task import TaskBaseAddForm
from pyams_skin.interfaces.viewlet import IToolbarAddingMenu
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarMenuItem
from pyams_utils.interfaces import MANAGE_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config

from pyams_content import _


@viewlet_config(name='add-glossary-updater-task.menu', context=ISite, layer=IPyAMSLayer,
                view=SchedulerTasksTable, manager=IToolbarAddingMenu,
                permission=MANAGE_SYSTEM_PERMISSION, weight=110)
class GlossaryUpdaterTaskAddMenu(ToolbarMenuItem):
    """Glossary updater task add menu"""

    label = _("Add glossary updater task...")
    label_css_class = 'fa fa-fw fa-book'
    url = 'add-glossary-updater-task.html'
    modal_target = True


@pagelet_config(name='add-glossary-updater-task.html', context=ISite, layer=IPyAMSLayer,
                permission=MANAGE_SYSTEM_PERMISSION)
@ajax_config(name='add-glossary-updater-task.json', context=ISite, layer=IPyAMSLayer,
             permission=MANAGE_SYSTEM_PERMISSION, base=AJAXAddForm)
class GlossaryUpdaterTaskAddForm(TaskBaseAddForm):
    """Glossary updater task add form"""

    legend = _("Add glossary updater")
    icon_css_class = 'fa fa-fw fa-book'

    task_factory = GlossaryUpdaterTask
