#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.interface import implementer
from zope.lifecycleevent import IObjectAddedEvent, IObjectModifiedEvent

from pyams_content.component.theme import ITagsManager
from pyams_content.features.glossary import get_glossary_automaton
from pyams_content.features.glossary.interfaces import IGlossaryUpdaterTask
from pyams_content.root import ISiteRoot
from pyams_scheduler.interfaces import IScheduler
from pyams_scheduler.task import Task
from pyams_thesaurus.interfaces.term import IThesaurusTerm
from pyams_utils.registry import get_utility
from pyams_utils.request import check_request
from pyams_utils.traversing import get_parent


@implementer(IGlossaryUpdaterTask)
class GlossaryUpdaterTask(Task):
    """Glossary updater task"""

    settings_view_name = None

    def run(self, report):
        root = get_parent(self, ISiteRoot)
        get_glossary_automaton(root)


@subscriber(IObjectAddedEvent, context_selector=IThesaurusTerm)
@subscriber(IObjectModifiedEvent, context_selector=IThesaurusTerm)
def handle_updated_thesaurus_term(event):
    """Reset glossary automaton on term update"""
    request = check_request()
    tags_manager = ITagsManager(request.root)
    if not tags_manager.enable_glossary:
        return
    scheduler = get_utility(IScheduler)
    for task in scheduler.values():
        if IGlossaryUpdaterTask.providedBy(task):
            task.launch()
            break
