#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.component.verbatim.portlet import IVerbatimPortletSettings
from pyams_content.component.verbatim.zmi import VerbatimsView
from pyams_form.form import AJAXEditForm
from pyams_form.interfaces.form import IInnerSubForm, IInnerTabForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_workflow.interfaces import IWorkflowPublicationInfo


__docformat__ = 'restructuredtext'

from pyams_content import _


@pagelet_config(name='properties.html', 
                context=IVerbatimPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class VerbatimPortletEditor(PortletSettingsEditor):
    """Verbatim portlet settings editor"""

    settings = IVerbatimPortletSettings


@adapter_config(name='properties', 
                context=(Interface, IPyAMSLayer, VerbatimPortletEditor), 
                provides=IInnerTabForm)
class VerbatimPortletSettingsPropertiesEditor(PortletSettingsPropertiesEditor):
    """Verbatim portlet settings properties editor"""


@adapter_config(name='properties.json', 
                context=(IVerbatimPortletSettings, IPyAMSLayer), 
                provides=IPagelet)
class VerbatimPortletAJAXEditor(AJAXEditForm, VerbatimPortletEditor):
    """Verbatim portlet settings editor, JSON renderer"""


#
# Verbatims portlet views
#

@adapter_config(name='verbatim-portlet-numbers',
                context=(IVerbatimPortletSettings, IPyAMSLayer, PortletSettingsPropertiesEditor),
                provides=IInnerSubForm)
class VerbatimPortletNumbersView(VerbatimsView):
    """Verbatim portlet numbers view"""

    title = _("Verbatims")
    weight = 10


#
# Verbatims portlet previewer
#

@adapter_config(context=(Interface, IPyAMSLayer, Interface, IVerbatimPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/verbatim-preview.pt', layer=IPyAMSLayer)
class VerbatimPortletPreviewer(PortletPreviewer):
    """Verbatim portlet previewer"""
