#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute, Interface

from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_portal.interfaces import IPortletSettings


__docformat__ = 'restructuredtext'

from pyams_content import _


class IVerbatimPortletSettings(IPortletSettings):
    """Verbatims portlet settings interface"""

    title = I18nTextLineField(title=_("Title"),
                              description=_("Portlet title"),
                              required=False)

    teaser = I18nTextField(title=_("Teaser"),
                           description=_("Short text displayed above verbatims"),
                           required=False)

    verbatims = Attribute("Verbatims list")


class IVerbatimPortletMenu(Interface):
    """Verbatims portlet menu marker interface"""
