#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.verbatim import IVerbatimContainer, IVerbatimContainerTarget
from pyams_content.component.verbatim.portlet.interfaces import IVerbatimPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION


__docformat__ = 'restructuredtext'

from pyams_content import _


VERBATIM_PORTLET_NAME = "pyams_portal.portlet.verbatim"


@factory_config(provided=IVerbatimPortletSettings)
@implementer(IVerbatimContainerTarget)
class VerbatimPortletSettings(PortletSettings):
    """Verbatim portlet settings"""

    title = FieldProperty(IVerbatimPortletSettings['title'])
    teaser = FieldProperty(IVerbatimPortletSettings['teaser'])

    @property
    def verbatims(self):
        return IVerbatimContainer(self)


@portlet_config(permission=VIEW_PERMISSION)
class VerbatimPortlet(Portlet):
    """Verbatim portlet"""

    name = VERBATIM_PORTLET_NAME
    label = _("Verbatims")

    toolbar_image = None
    toolbar_css_class = 'fa fa-fw fa-2x fa-dashboard'

    settings_factory = IVerbatimPortletSettings
