#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from colander import MappingSchema, SchemaNode, SequenceSchema, String, drop

from pyams_content.reference.pictograms.api.schema import PictogramsMapping
from pyams_utils.rest import StringListSchema

__docformat__ = 'restructuredtext'


class ThesaurusTermInfo(MappingSchema):
    """Thesaurus term info schema"""
    name = SchemaNode(String(),
                      description="Term internal name")
    label = SchemaNode(String(),
                       description="Term public label")
    definition = SchemaNode(String(),
                            description="Term additional definition",
                            missing=drop)
    note = SchemaNode(String(),
                      description="Term application note",
                      missing=drop)
    pictograms = PictogramsMapping(description="Pictograms information",
                                   missing=drop)


class ThesaurusTermsList(SequenceSchema):
    """Thesaurus terms list schema"""
    content = ThesaurusTermInfo()


class TermsListInfo(MappingSchema):
    """Generic thesaurus terms info schema"""
    items = StringListSchema(description="Terms list",
                             missing=drop)
