#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import button
from z3c.form.interfaces import INPUT_MODE
from zope.interface import implementer

from pyams_content.component.paragraph.interfaces.header import IHeaderParagraph
from pyams_content.component.paragraph.zmi import BaseParagraphAJAXEditForm, BaseParagraphPropertiesEditForm, \
    IParagraphInnerEditFormButtons, get_json_paragraph_refresh_event
from pyams_content.component.paragraph.zmi.interfaces import IParagraphInnerEditor
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.event import get_json_widget_refresh_event
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config

from pyams_content import _


@pagelet_config(name='properties.html', context=IHeaderParagraph, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='properties.json', context=IHeaderParagraph, layer=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
class HeaderParagraphPropertiesEditForm(BaseParagraphPropertiesEditForm):
    """Header paragraph properties edit form"""

    prefix = 'header_properties.'

    legend = _("Edit header paragraph properties")

    content_interface = IHeaderParagraph

    @property
    def fields(self):
        return super(HeaderParagraphPropertiesEditForm, self).fields.omit('title')

    def updateWidgets(self, prefix=None):
        super(HeaderParagraphPropertiesEditForm, self).updateWidgets(prefix)
        if 'header' in self.widgets:
            self.widgets['header'].widget_css_class = 'input height-100'

    def get_ajax_output(self, changes):
        output = super(self.__class__, self).get_ajax_output(changes)
        updated = changes.get(IHeaderParagraph, ())
        if 'header' in updated:
            output.setdefault('events', []).append(get_json_paragraph_refresh_event(self.context, self.request))
        if 'renderer' in updated:
            output.setdefault('events', []).append(get_json_widget_refresh_event(self.context, self.request,
                                                                                 HeaderParagraphInnerEditForm,
                                                                                 'renderer'))
        return output


@adapter_config(context=(IHeaderParagraph, IPyAMSLayer), provides=IParagraphInnerEditor)
@ajax_config(name='inner-properties.json', context=IHeaderParagraph, layer=IPyAMSLayer,
             base=BaseParagraphAJAXEditForm)
@implementer(IInnerForm)
class HeaderParagraphInnerEditForm(HeaderParagraphPropertiesEditForm):
    """Header paragraph inner edit form"""

    legend = None
    label_css_class = 'control-label col-md-2'
    input_css_class = 'col-md-10'

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IParagraphInnerEditFormButtons)
        else:
            return button.Buttons()
