#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_content.interfaces.container import IOrderedContainer
from pyams_content.reference.pictograms.interfaces import SELECTED_PICTOGRAM_VOCABULARY
from zope.annotation import IAttributeAnnotatable

# import packages
from pyams_i18n.schema import I18nTextLineField, I18nTextField
from zope.container.constraints import containers, contains
from zope.interface import Interface, Attribute
from zope.schema import Bool, Choice

from pyams_content import _


PICTOGRAM_CONTAINER_KEY = 'pyams_content.pictograms'


class IPictogramItem(IAttributeAnnotatable):
    """Pictogram item interface"""

    containers('.IPictogramContainer')

    visible = Bool(title=_("Visible?"),
                   description=_("Is this pictogram visible in front-office?"),
                   required=True,
                   default=True)

    pictogram_name = Choice(title=_("Pictogram"),
                            description=_("Name of the pictogram to select"),
                            required=False,
                            vocabulary=SELECTED_PICTOGRAM_VOCABULARY)

    pictogram = Attribute("Select pictogram object")

    label = I18nTextLineField(title=_("Alternate header"),
                              description=_("Alternate pictogram label; if not specified, the pictogram header "
                                            "will be used"),
                              required=False)

    body = I18nTextField(title=_("Associated text"),
                         description=_("Additional text associated to this pictogram"),
                         required=False)


class IPictogramContainer(IOrderedContainer):
    """Pictogram items container interface"""

    contains(IPictogramItem)

    def append(self, value, notify=True):
        """Append given pictogram item to container"""

    def get_visible_items(self):
        """Get list of visible pictogram items"""


class IPictogramContainerTarget(Interface):
    """Pictogram container target interface"""


PICTOGRAM_PARAGRAPH_TYPE = 'Pictograms'
PICTOGRAM_PARAGRAPH_NAME = _("Pictograms")
PICTOGRAM_PARAGRAPH_RENDERERS = 'MyAMS.pictograms.renderers'


class IPictogramParagraph(IPictogramContainerTarget, IBaseParagraph):
    """Pictograms paragraph interface"""

    renderer = Choice(title=_("Pictograms template"),
                      description=_("Presentation template used for pictograms"),
                      vocabulary=PICTOGRAM_PARAGRAPH_RENDERERS,
                      default='default')
