#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation.interfaces import IAttributeAnnotatable
from zope.container.constraints import containers, contains
from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice

from pyams_content.component.paragraph import CONTENT_PARAGRAPHS_VOCABULARY, IBaseParagraph
from pyams_content.interfaces.container import IOrderedContainer
from pyams_content.reference.pictograms.interfaces import SELECTED_PICTOGRAM_VOCABULARY
from pyams_i18n.schema import I18nTextField, I18nTextLineField


__docformat__ = 'restructuredtext'

from pyams_content import _


MILESTONE_CONTAINER_KEY = 'pyams_content.milestones'


class IMilestone(IAttributeAnnotatable):
    """Base milestone interface"""

    containers('.IMilestoneContainer')

    visible = Bool(title=_("Visible?"),
                   description=_("Is this milestone visible in front-office?"),
                   required=True,
                   default=True)

    title = I18nTextLineField(title=_("Title"),
                              description=_("Milestone title"),
                              required=True)

    label = I18nTextField(title=_("Associated label"),
                          description=_("The way this label will be rendered depends on "
                                        "presentation template"),
                          required=False)

    pictogram_name = Choice(title=_("Pictogram"),
                            description=_("Name of the pictogram associated with this milestone"),
                            required=False,
                            vocabulary=SELECTED_PICTOGRAM_VOCABULARY)

    pictogram = Attribute("Selected pictogram object")

    anchor = Choice(title=_("Anchor"),
                    description=_("Paragraph to which this milestone should lead"),
                    vocabulary=CONTENT_PARAGRAPHS_VOCABULARY,
                    required=False)

    target = Attribute("Anchor target")


class IMilestoneContainer(IOrderedContainer):
    """Milestones container interface"""

    contains(IMilestone)

    def append(self, value, notify=True):
        """Append given milestone to container"""

    def get_visible_items(self):
        """Get list of visible milestones"""


class IMilestoneContainerTarget(Interface):
    """Milestones container target interface"""


MILESTONE_PARAGRAPH_TYPE = 'Milestones'
MILESTONE_PARAGRAPH_NAME = _("Milestones")
MILESTONE_PARAGRAPH_RENDERERS = 'PyAMS.milestones.renderers'


class IMilestoneParagraph(IMilestoneContainerTarget, IBaseParagraph):
    """Milestones paragraph interface"""

    body = I18nTextField(title=_("Associated text"),
                         description=_("Additional text associated to this milestone paragraph"),
                         required=False)

    renderer = Choice(title=_("Milestones template"),
                      description=_("Presentation template used for milestones"),
                      vocabulary=MILESTONE_PARAGRAPH_RENDERERS,
                      default='default')
