#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Choice

from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_i18n.schema import I18nHTMLField, I18nTextField

from pyams_content import _


#
# Raw HTML paragraph
#

RAW_PARAGRAPH_TYPE = 'raw'
RAW_PARAGRAPH_NAME = _("Raw source")
RAW_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.raw.renderers'


class IRawParagraph(IBaseParagraph):
    """Raw HTML paragraph interface"""

    body = I18nTextField(title=_("Source code"),
                         description=_("<span>This code will be used 'as is', without any "
                                       "transformation, if using the 'raw' renderer. Use with "
                                       "care!!<br />Press &lt;CTRL&gt;+&lt;,&gt; to display "
                                       "editor options...</span>"),
                         required=False)

    renderer = Choice(title=_("Source code template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=RAW_PARAGRAPH_RENDERERS,
                      default='default')


#
# HTML paragraph
#

HTML_PARAGRAPH_TYPE = 'HTML'
HTML_PARAGRAPH_NAME = _("Rich text")
HTML_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.html.renderers'


class IHTMLParagraph(IBaseParagraph):
    """Rich text paragraph interface"""

    body = I18nHTMLField(title=_("Body"),
                         required=False)

    renderer = Choice(title=_("Body template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=HTML_PARAGRAPH_RENDERERS,
                      default='default')
