#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph

# import packages
from pyams_i18n.schema import I18nHTMLField
from zope.schema import Choice

from pyams_content import _


#
# Text paragraph
#

FRAME_PARAGRAPH_TYPE = 'FramedText'
FRAME_PARAGRAPH_NAME = _("Framed text")
FRAME_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.text.renderers'


class IFrameParagraph(IBaseParagraph):
    """Framed text paragraph interface"""

    body = I18nHTMLField(title=_("Frame body"),
                         required=False)

    renderer = Choice(title=_("Text template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=FRAME_PARAGRAPH_RENDERERS,
                      default='default')
