#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import IWfSharedContent
from pyams_file.interfaces import IMediaFile, IThumbnailFile
from zope.lifecycleevent.interfaces import IObjectAddedEvent, IObjectModifiedEvent, IObjectRemovedEvent

# import packages
from pyams_utils.traversing import get_parent
from pyramid.events import subscriber
from pyramid.threadlocal import get_current_registry
from zope.lifecycleevent import ObjectModifiedEvent


@subscriber(IObjectAddedEvent, context_selector=IMediaFile)
def handle_added_media(event):
    """Handle added media file"""
    media = event.object
    if IThumbnailFile.providedBy(media):
        return
    content = get_parent(media, IWfSharedContent)
    if content is not None:
        get_current_registry().notify(ObjectModifiedEvent(content))


@subscriber(IObjectModifiedEvent, context_selector=IMediaFile)
def handle_modified_media(event):
    """Handle modified media file"""
    media = event.object
    if IThumbnailFile.providedBy(media):
        return
    content = get_parent(media, IWfSharedContent)
    if content is not None:
        get_current_registry().notify(ObjectModifiedEvent(content))


@subscriber(IObjectRemovedEvent, context_selector=IMediaFile)
def handle_removed_media(event):
    """Handle removed media file"""
    media = event.object
    if IThumbnailFile.providedBy(media):
        return
    content = get_parent(media, IWfSharedContent)
    if content is not None:
        get_current_registry().notify(ObjectModifiedEvent(content))
