#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget, \
        IBaseParagraph
    from pyams_content.component.map.interfaces import IMapParagraph, MAP_PARAGRAPH_TYPE
    from pyams_content.component.paragraph.zmi.interfaces import IParagraphInnerEditor
    from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
    from pyams_form.interfaces.form import IInnerForm
    from pyams_skin.interfaces.viewlet import IToolbarAddingMenu
    from pyams_skin.layer import IPyAMSLayer
    from z3c.form.interfaces import INPUT_MODE

    from pyams_content.component.map.paragraph import MapParagraph
    from pyams_content.component.paragraph.zmi import IParagraphContainerView, \
        BaseParagraphAddMenu, BaseParagraphAJAXAddForm, BaseParagraphAJAXEditForm, \
        BaseParagraphPropertiesEditForm, get_json_paragraph_refresh_event, \
        IParagraphInnerEditFormButtons, BaseParagraphAddForm
    from pyams_form.form import ajax_config
    from pyams_pagelet.pagelet import pagelet_config
    from pyams_skin.event import get_json_form_refresh_event
    from pyams_utils.adapter import adapter_config
    from pyams_viewlet.viewlet import viewlet_config
    from z3c.form import button
    from zope.interface import implementer

    from pyams_content import _


    @viewlet_config(name='add-map-paragraph.menu',
                    context=IParagraphContainerTarget, view=IParagraphContainerView,
                    layer=IPyAMSLayer, manager=IToolbarAddingMenu, weight=600)
    class MapParagraphAddMenu(BaseParagraphAddMenu):
        """Map paragraph add menu"""

        label = _("Location map...")
        label_css_class = 'fa fa-fw ' + MapParagraph.icon_class
        url = 'add-map-paragraph.html'
        paragraph_type = MAP_PARAGRAPH_TYPE


    @pagelet_config(name='add-map-paragraph.html',
                    context=IParagraphContainerTarget, layer=IPyAMSLayer,
                    permission=MANAGE_CONTENT_PERMISSION)
    @ajax_config(name='add-map-paragraph.json',
                 context=IParagraphContainerTarget, layer=IPyAMSLayer,
                 base=BaseParagraphAJAXAddForm)
    class MapParagraphAddForm(BaseParagraphAddForm):
        """Map paragraph add form"""

        legend = _("Add new location map")
        dialog_class = 'modal-large'

        content_interface = IMapParagraph


    @pagelet_config(name='properties.html',
                    context=IMapParagraph, layer=IPyAMSLayer,
                    permission=MANAGE_CONTENT_PERMISSION)
    @ajax_config(name='properties.json',
                 context=IMapParagraph, request_type=IPyAMSLayer,
                 base=BaseParagraphAJAXEditForm)
    class MapParagraphPropertiesEditForm(BaseParagraphPropertiesEditForm):
        """Map paragraph properties edit form"""

        prefix = 'map_properties.'

        legend = _("Edit location map properties")

        content_interface = IMapParagraph

        def get_ajax_output(self, changes):
            output = super(self.__class__, self).get_ajax_output(changes)
            updated = changes.get(IBaseParagraph, ())
            if 'title' in updated:
                output.setdefault('events', []).append(
                    get_json_paragraph_refresh_event(self.context, self.request))
            updated = changes.get(IMapParagraph, ())
            if 'renderer' in updated:
                output.setdefault('events', []).append(
                    get_json_form_refresh_event(self.context, self.request,
                                                MapParagraphInnerEditForm))
            return output


    @adapter_config(context=(IMapParagraph, IPyAMSLayer),
                    provides=IParagraphInnerEditor)
    @ajax_config(name='inner-properties.json',
                 context=IMapParagraph, layer=IPyAMSLayer,
                 base=BaseParagraphAJAXEditForm)
    @implementer(IInnerForm)
    class MapParagraphInnerEditForm(MapParagraphPropertiesEditForm):
        """Map paragraph inner edit form"""

        legend = None

        @property
        def buttons(self):
            if self.mode == INPUT_MODE:
                return button.Buttons(IParagraphInnerEditFormButtons)
            return button.Buttons()
