#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from z3c.form.field import Fields
    from zope.interface import Interface

    from pyams_content.component.map.portlet import IMapPortletSettings
    from pyams_form.form import AJAXEditForm
    from pyams_form.interfaces.form import IInnerTabForm
    from pyams_pagelet.interfaces import IPagelet
    from pyams_pagelet.pagelet import pagelet_config
    from pyams_portal.interfaces import IPortletPreviewer
    from pyams_portal.portlet import PortletPreviewer
    from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
    from pyams_portal.zmi.widget import PortletRendererFieldWidget
    from pyams_skin.layer import IPyAMSLayer
    from pyams_template.template import template_config
    from pyams_utils.adapter import adapter_config
    from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


    @pagelet_config(name='properties.html',
                    context=IMapPortletSettings, layer=IPyAMSLayer,
                    permission=VIEW_SYSTEM_PERMISSION)
    class MapPortletEditor(PortletSettingsEditor):
        """Map portlet settings editor"""

        settings = IMapPortletSettings


    @adapter_config(name='properties',
                    context=(Interface, IPyAMSLayer, MapPortletEditor),
                    provides=IInnerTabForm)
    class MapPortletSettingsPropertiesEditor(PortletSettingsPropertiesEditor):
        """Map portlet settings properties editor"""

        @property
        def fields(self):
            fields = Fields(IMapPortletSettings).select('title') + \
                Fields(IMapPortletSettings).omit('__name__', 'renderer', 'title') + \
                Fields(IMapPortletSettings).select('renderer')
            fields['renderer'].widgetFactory = PortletRendererFieldWidget
            return fields


    @adapter_config(name='properties.json',
                    context=(IMapPortletSettings, IPyAMSLayer),
                    provides=IPagelet)
    class MapPortletAJAXEditor(AJAXEditForm, MapPortletEditor):
        """Map portlet settings editor, JSON renderer"""


    #
    # Map portlet previewer
    #

    @adapter_config(context=(Interface, IPyAMSLayer, Interface, IMapPortletSettings),
                    provides=IPortletPreviewer)
    @template_config(template='templates/map-preview.pt', layer=IPyAMSLayer)
    class MapPortletPreviewer(PortletPreviewer):
        """Map portlet previewer"""
