#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.schema.fieldproperty import FieldProperty

    from pyams_content.component.map import BaseMapSettings
    from pyams_content.component.map.portlet.interfaces import IMapPortletSettings
    from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
    from pyams_utils.factory import factory_config
    from pyams_utils.interfaces import VIEW_PERMISSION

    from pyams_content import _


    MAP_PORTLET_NAME = "pyams_content.portlet.map"


    @factory_config(provided=IMapPortletSettings)
    class MapPortletSettings(PortletSettings, BaseMapSettings):
        """Map portlet settings"""

        title = FieldProperty(IMapPortletSettings['title'])


    @portlet_config(permission=VIEW_PERMISSION)
    class MapPortlet(Portlet):
        """Map portlet"""

        name = MAP_PORTLET_NAME
        label = _("Location map")

        toolbar_image = None
        toolbar_css_class = 'fa fa-fw fa-2x fa-map-marker-alt'

        settings_factory = IMapPortletSettings
