#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


try:
    from pyams_gis.schema import GeoPointField
except ImportError:
    GeoPointField = None
    have_gis = False
else:
    have_gis = True


    from zope.interface import Interface
    from zope.schema import Bool, Choice

    from pyams_content.component.paragraph import IBaseParagraph
    from pyams_gis.schema import GeoPointField

    from pyams_content import _


    MAP_PARAGRAPH_TYPE = 'Map'
    MAP_PARAGRAPH_NAME = _("Location map")
    MAP_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.map.renderers'


    class IBaseMapSettings(Interface):
        """Base map settings interface"""

        gps_location = GeoPointField(title=_("GPS location"),
                                     description=_("GPS coordinates used to locate map"),
                                     required=False)

        display_marker = Bool(title=_("Display location mark?"),
                              description=_("If 'yes', a location marker will be displayed on map"),
                              required=True,
                              default=True)

        display_coordinates = Bool(title=_("Display coordinates?"),
                                   description=_("If 'yes', GPS coordinates (if GPS position "
                                                 "is defined) will be displayed below the map"),
                                   required=True,
                                   default=False)


    class IMapParagraph(IBaseParagraph, IBaseMapSettings):
        """Map paragraph interface"""

        renderer = Choice(title=_("Map template"),
                          description=_("Presentation template used for this map"),
                          vocabulary=MAP_PARAGRAPH_RENDERERS,
                          default='default')
