#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.association.interfaces import IAssociationContainer, IAssociationContainerTarget, \
    IAssociationInfo
from pyams_content.component.extfile.interfaces import IBaseExtFile
from pyams_content.component.links.interfaces import IBaseLink
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url
from pyramid.view import view_config
from zope.interface import Interface


#
# Links container views
#

@view_config(name='get-links.json', context=Interface, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
def get_links(request):
    """Get links list in JSON format for TinyMCE editor"""
    result = []
    key_field_name = request.params.get('keyFieldName', 'title')
    value_field_name = request.params.get('valueFieldName', 'value')
    target = get_parent(request.context, IAssociationContainerTarget)
    if target is not None:
        container = IAssociationContainer(target)
        result.extend([{key_field_name: item.__name__,
                        value_field_name: IAssociationInfo(item).user_title}
                       for item in container.values()])
    return sorted(result, key=lambda x: x[value_field_name])


@view_config(name='get-links-list.json', context=Interface, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
def get_links_list(request):
    """Get links list in JSON format for TinyMCE editor"""
    result = []
    target = get_parent(request.context, IAssociationContainerTarget)
    if target is not None:
        container = IAssociationContainer(target)
        for item in container.values():
            if IBaseLink.providedBy(item):
                result.append({'title': IAssociationInfo(item).user_title,
                               'value': item.get_editor_url()})
            elif IBaseExtFile.providedBy(item):
                result.append({'title': IAssociationInfo(item).user_title,
                               'value': absolute_url(II18n(item).query_attribute('data', request=request),
                                                     request=request)})
    return sorted(result, key=lambda x: x['title'])
