#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#


__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.component.keynumber.portlet.interfaces import IKeyNumberPortletSettings, IKeyNumberPortletMenu
from pyams_content.features.menu.zmi import IMenuLinksView
from pyams_content.component.links.interfaces import IInternalLink
from pyams_portal.interfaces import IPortletPreviewer
from pyams_form.interfaces.form import IInnerSubForm, IInnerTabForm
from pyams_pagelet.interfaces import IPagelet
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_workflow.interfaces import IWorkflowPublicationInfo

# import packages
from pyams_content.component.keynumber.portlet import KEYNUMBER_PORTLET_LINKS_NAME
from pyams_content.component.keynumber.zmi import KeyNumbersView
from pyams_content.features.menu.zmi import MenuLinksView, LinksTable
from pyams_form.form import AJAXEditForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from zope.interface import Interface

from pyams_content import _


@pagelet_config(name='properties.html', context=IKeyNumberPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class KeyNumberPortletEditor(PortletSettingsEditor):
    """Key number portlet settings editor"""

    settings = IKeyNumberPortletSettings


@adapter_config(name='properties', context=(Interface, IPyAMSLayer, KeyNumberPortletEditor), provides=IInnerTabForm)
class KeyNumberPortletSettingsPropertiesEditor(PortletSettingsPropertiesEditor):
    """Key number portlet settings properties editor"""


@adapter_config(name='properties.json', context=(IKeyNumberPortletSettings, IPyAMSLayer), provides=IPagelet)
class KeyNumberPortletAJAXEditor(AJAXEditForm, KeyNumberPortletEditor):
    """Key number portlet settings editor, JSON renderer"""


#
# Key numbers portlet numbers view
#

@adapter_config(name='keynumber-portlet-numbers',
                context=(IKeyNumberPortletSettings, IPyAMSLayer, PortletSettingsPropertiesEditor),
                provides=IInnerSubForm)
class KeyNumberPortletNumbersView(KeyNumbersView):
    """Key number portlet numbers view"""

    title = _("Key numbers")
    weight = 10


#
# Key numbers portlet links view
#

class KeyNumberPortletLinksTable(LinksTable):
    """Key Numbers links associations table"""

    associations_name = KEYNUMBER_PORTLET_LINKS_NAME


@adapter_config(name='keynumber-portlet-links',
                context=(IKeyNumberPortletSettings, IPyAMSLayer, PortletSettingsPropertiesEditor),
                provides=IInnerSubForm)
@adapter_config(name='++ass++{0}'.format(KEYNUMBER_PORTLET_LINKS_NAME),
                context=(IKeyNumberPortletMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class KeyNumberPortletLinksView(MenuLinksView):
    """Key numbers portlet links view"""

    title = _("Associated links")
    weight = 20

    table_class = KeyNumberPortletLinksTable


#
# Key numbers portlet previewer
#

@adapter_config(context=(Interface, IPyAMSLayer, Interface, IKeyNumberPortletSettings), provides=IPortletPreviewer)
@template_config(template='templates/keynumber-preview.pt', layer=IPyAMSLayer)
class KeyNumberPortletPreviewer(PortletPreviewer):
    """Key number portlet previewer"""

    @classmethod
    def get_link_info(cls, link):
        return IAssociationInfo(link)

    @classmethod
    def get_link_status(cls, link):
        if not IInternalLink.providedBy(link):
            return True
        target = link.get_target()
        return (target is not None) and IWorkflowPublicationInfo(target).is_published()
