#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_content.interfaces.container import IOrderedContainer
from zope.annotation.interfaces import IAttributeAnnotatable

# import packages
from pyams_i18n.schema import I18nTextLineField
from zope.container.constraints import containers, contains
from zope.interface import Interface
from zope.schema import Bool, TextLine, Choice

from pyams_content import _


KEYNUMBER_CONTAINER_KEY = 'pyams_content.keynumbers'


class IKeyNumber(IAttributeAnnotatable):
    """Base key number interface"""

    containers('.IKeyNumberContainer')

    visible = Bool(title=_("Visible?"),
                   description=_("Is this key number visible in front-office?"),
                   required=True,
                   default=True)

    label = I18nTextLineField(title=_('key-number-label', default="Header"),
                              description=_("Small text to be displayed above number (according to selected "
                                            "renderer)"),
                              required=False)

    number = TextLine(title=_("Number"),
                      description=_("Key number value"),
                      required=False)

    unit = I18nTextLineField(title=_('key-number-unit', default="Unit"),
                             description=_("Displayed unit"),
                             required=False)

    text = I18nTextLineField(title=_("Associated text"),
                             description=_("The way this text will be rendered depends on presentation template"),
                             required=False)


KEYNUMBER_HIDDEN_FIELDS = ('__parent__', '__name__', 'visible')


class IKeyNumberContainer(IOrderedContainer):
    """Key numbers container interface"""

    contains(IKeyNumber)

    def append(self, value, notify=True):
        """Append given key number to container"""

    def get_visible_items(self):
        """Get list of visible key numbers"""


class IKeyNumberContainerTarget(Interface):
    """Key numbers container target interface"""


KEYNUMBER_PARAGRAPH_TYPE = 'KeyNumbers'
KEYNUMBER_PARAGRAPH_NAME = _("Key numbers")
KEYNUMBER_PARAGRAPH_RENDERERS = 'PyAMS.keynumbers.renderers'


#
# KeyNumber paragraph
#

class IKeyNumberParagraph(IKeyNumberContainerTarget, IBaseParagraph):
    """Key numbers paragraph interface"""

    renderer = Choice(title=_("Key numbers template"),
                      description=_("Presentation template used for key numbers"),
                      vocabulary=KEYNUMBER_PARAGRAPH_RENDERERS,
                      default='default')
