#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.illustration import IBasicIllustrationTarget
from pyams_thesaurus.interfaces.extension import IThesaurusTermExtension
from pyams_utils.registry import utility_config

from pyams_content import _


@utility_config(name='illustration', provides=IThesaurusTermExtension)
class IllustrationThesaurusExtension(object):
    """Illustration thesaurus extension"""

    label = _("Illustration")
    weight = 20

    target_interface = IBasicIllustrationTarget
    target_view = 'illustration-dialog.html'

    icon = '<i class="fa fa-fw fa-file-image-o"></i>'
