#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from builtins import LookupError

from zope.interface import Interface

from pyams_content.component.illustration.portlet import IIllustrationPortletSettings
from pyams_content.component.illustration.portlet.interfaces import \
    ILLUSTRATION_DISPLAY_VOCABULARY
from pyams_form.form import AJAXEditForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='properties.html',
                context=IIllustrationPortletSettings, request_type=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class IllustrationPortletSettingsEditor(PortletSettingsEditor):
    """Illustration settings editor"""

    settings = IIllustrationPortletSettings


@adapter_config(name='properties.json',
                context=(IIllustrationPortletSettings, IPyAMSLayer),
                provides=IPagelet)
class IllustrationPortletSettingsAJAXEditor(AJAXEditForm, IllustrationPortletSettingsEditor):
    """Illustration portlet settings AJAX renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface, IIllustrationPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/preview.pt', layer=IPyAMSLayer)
class IllustrationPortletPreviewer(PortletPreviewer):
    """Illustration portlet previewer"""

    @property
    def selected_display(self):
        vocabulary = ILLUSTRATION_DISPLAY_VOCABULARY
        try:
            term = vocabulary.getTerm(self.settings.display)
        except LookupError:
            return '--'
        else:
            translate = self.request.localizer.translate
            return translate(term.title)
