#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation.interfaces import IAttributeAnnotatable
from zope.interface import Interface
from zope.schema import Choice, TextLine

from pyams_content import _
from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_content.features.renderer.interfaces import IRenderedContent
from pyams_i18n.schema import I18nTextField, I18nTextLineField, I18nThumbnailMediaField


#
# Illustration
#

BASIC_ILLUSTRATION_KEY = 'pyams_content.illustration.base'

ILLUSTRATION_KEY = 'pyams_content.illustration'
ILLUSTRATION_RENDERERS = 'PyAMS.illustration.renderers'

LINK_ILLUSTRATION_KEY = '{0}::link'.format(ILLUSTRATION_KEY)


class IBasicIllustration(Interface):
    """Basic illustration interface"""

    data = I18nThumbnailMediaField(title=_("Image or video data"),
                                   description=_("Image or video content"),
                                   required=False)

    def has_data(self):
        """Check if data is provided in any language"""

    title = I18nTextLineField(title=_("Legend"),
                              required=False)

    alt_title = I18nTextLineField(title=_("Accessibility title"),
                                  description=_("Alternate title used to describe image content"),
                                  required=False)

    author = TextLine(title=_("Author"),
                      description=_("Name of picture's author"),
                      required=False)


class IIllustration(IBasicIllustration, IRenderedContent):
    """Illustration paragraph"""

    description = I18nTextField(title=_("Associated text"),
                                description=_("Illustration description displayed in front-office templates"),
                                required=False)

    renderer = Choice(title=_("Illustration template"),
                      description=_("Presentation template used for illustration"),
                      vocabulary=ILLUSTRATION_RENDERERS,
                      default='default')


class ILinkIllustration(IBasicIllustration):
    """Navigation link illustration interface"""


class IIllustrationTargetBase(IAttributeAnnotatable):
    """Illustration target base interface"""


class IBasicIllustrationTarget(IIllustrationTargetBase):
    """Basic illustration target marker interface"""


class IIllustrationTarget(IBasicIllustrationTarget):
    """Illustration target interface"""


class ILinkIllustrationTarget(IIllustrationTargetBase):
    """Link illustration target interface"""


#
# Illustration paragraph
#

ILLUSTRATION_PARAGRAPH_TYPE = 'Illustration'
ILLUSTRATION_PARAGRAPH_NAME = _("Illustration")


class IIllustrationParagraph(IIllustration, IBaseParagraph):
    """Illustration paragraph"""

    data = I18nThumbnailMediaField(title=_("Image or video data"),
                                   description=_("Image or video content"),
                                   required=True)
