#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyams_content.component.illustration import IIllustration, IIllustrationTarget, ILinkIllustration, \
    ILinkIllustrationTarget
from pyams_content.features.json import JSONBaseConverter
from pyams_content.features.json.interfaces import IJSONConverter
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


@adapter_config(required=(IIllustration, IPyAMSLayer),
                provides=IJSONConverter)
class JSONIllustrationConverter(JSONBaseConverter):
    """JSON illustration converter"""

    is_inner = False

    def convert_content(self, params):
        result = super().convert_content(params)
        self.convert_illustration(self.conversion_target, params, result)
        return result

    def convert_illustration(self, illustration, params, result):
        if not illustration:
            return
        src = self.get_image_url(illustration, 'data', params)
        if not src:
            return
        result.update({
            'src': src
        })
        self.get_i18n_attribute(illustration, 'title', params.get('lang'), result)
        self.get_i18n_attribute(illustration, 'alt_title', params.get('lang'), result)
        self.get_attribute(illustration, 'author', result)
        self.get_i18n_attribute(illustration, 'description', params.get('lang'), result)


@adapter_config(name='illustration',
                required=(IIllustrationTarget, IPyAMSLayer),
                provides=IJSONConverter)
class JSONIllustrationTargetConverter(JSONIllustrationConverter):
    """JSON shared content illustration converter"""

    is_inner = True

    @property
    def conversion_target(self):
        return IIllustration(self.context, None)


@adapter_config(name='link_illustration',
                required=(ILinkIllustrationTarget, IPyAMSLayer),
                provides=IJSONConverter)
class JSONLinkIllustrationTargetConverter(JSONIllustrationConverter):
    """JSON shared content link illustration converter"""

    is_inner = True

    @property
    def conversion_target(self):
        return ILinkIllustration(self.context, None)
