#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces

from zope.interface import Interface
from zope.schema import TextLine

from pyams_content import _
# import packages
from pyams_file.schema import FileField


class IGalleryContentsView(Interface):
    """Marker interface for gallery contents view"""


class IGalleryMediasAddFields(Interface):
    """Gallery medias add fields"""

    medias_data = FileField(title=_("Images or videos data"),
                            description=_("You can upload a single file or choose to upload a whole ZIP archive"),
                            required=True)

    author = TextLine(title=_("Author"),
                      description=_("Name of document's author"),
                      required=True)
