#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.component.gallery.portlet.interfaces import IGalleryPortletSettings
from pyams_form.form import AJAXEditForm
from pyams_form.interfaces.form import IInnerTabForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


__docformat__ = 'restructuredtext'


#
# Shared content gallery portlet views
#

@pagelet_config(name='properties.html', 
                context=IGalleryPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class GalleryPortletSettingsEditor(PortletSettingsEditor):
    """Gallery portlet settings editor"""

    settings = IGalleryPortletSettings


@adapter_config(name='properties', 
                context=(Interface, IPyAMSLayer, GalleryPortletSettingsEditor),
                provides=IInnerTabForm)
class GalleryPortletSettingsPropertiesEditor(PortletSettingsPropertiesEditor):
    """Gallery portlet settings properties editor"""


@adapter_config(name='properties.json', 
                context=(IGalleryPortletSettings, IPyAMSLayer),
                provides=IPagelet)
class GalleryPortletAJAXEditor(AJAXEditForm, GalleryPortletSettingsEditor):
    """Gallery portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface, IGalleryPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/gallery-preview.pt', layer=IPyAMSLayer)
class GalleryPortletPreviewer(PortletPreviewer):
    """Gallery portlet previewer"""
