#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyams_content.component.gallery.portlet.interfaces import \
    IGalleryPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from zope.schema.fieldproperty import FieldProperty


__docformat__ = 'restructuredtext'

from pyams_content import _


#
# Shared content gallery portlet
#

GALLERY_PORTLET_NAME = 'pyams_content.portlet.gallery'


@factory_config(provided=IGalleryPortletSettings)
class GalleryPortletSettings(PortletSettings):
    """Gallery portlet settings"""

    title = FieldProperty(IGalleryPortletSettings['title'])


@portlet_config(permission=VIEW_PERMISSION)
class GalleryPortlet(Portlet):
    """Gallery portlet"""

    name = GALLERY_PORTLET_NAME
    label = _("Gallery portlet")

    toolbar_css_class = 'fa fa-fw fa-2x fa-picture-o'

    settings_factory = IGalleryPortletSettings
