#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from pyams_content.component.gallery import IGallery, IGalleryTarget
from pyams_content.component.gallery.interfaces import IGalleryFile, IGalleryParagraph
from pyams_content.component.paragraph.api import JSONParagraphConverter
from pyams_content.features.json import JSONBaseConverter
from pyams_content.features.json.interfaces import IJSONConverter
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


@adapter_config(required=(IGalleryFile, IPyAMSLayer),
                provides=IJSONConverter)
class JSONGalleryFileConverter(JSONBaseConverter):
    """JSON gallery file converter"""

    def convert_content(self, params):
        result = super().convert_content(params)
        src = self.get_image_url(self.context, 'data', params)
        if src is None:
            return result
        result.update({
            'src': src
        })
        self.get_i18n_attribute(self.context, 'title', params.get('lang'), result)
        self.get_i18n_attribute(self.context, 'alt_title', params.get('lang'), result)
        self.get_i18n_attribute(self.context, 'description', params.get('lang'), result)
        self.get_attribute(self.context, 'author', result)
        src = self.get_file_url(self.context, 'sound', result)
        if src:
            audio = {
                'src': src
            }
            self.get_i18n_attribute(self.context, 'sound_title', params.get('lang'), audio,
                                    name='title')
            self.get_i18n_attribute(self.context, 'sound_description', params.get('lang'), audio,
                                    name='description')
            result['audio'] = audio
        return result


@adapter_config(required=(IGalleryParagraph, IPyAMSLayer),
                provides=IJSONConverter)
class JSONGalleryParagraphConverter(JSONParagraphConverter):
    """JSON gallery paragraph converter"""

    def convert_content(self, params):
        result = super().convert_content(params)
        self.get_list_attribute(IGalleryParagraph(self.context).get_visible_medias(),
                                params, result, 'items')
        return result


@adapter_config(name='gallery',
                required=(IGalleryTarget, IPyAMSLayer),
                provides=IJSONConverter)
class JSONGalleryConverter(JSONBaseConverter):
    """JSON gallery converter"""

    is_inner = True

    @property
    def conversion_target(self):
        return None

    def convert_content(self, params):
        result = {}
        self.get_list_attribute(IGallery(self.context).get_visible_medias(),
                                params, result, 'items')
        return result
