#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.exceptions import NotFound
from pyramid.location import lineage
from pyramid.view import view_config

from pyams_file.interfaces import IFile
from pyams_file.views.file import FileView
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_workflow.interfaces import IWorkflowPublicationInfo


__docformat__ = 'restructuredtext'


@view_config(context=IFile, request_type=IPyAMSUserLayer)
def ProtectedFileView(request):
    """Protected file view"""
    context = request.context
    if not request.has_permission(VIEW_SYSTEM_PERMISSION, context=context):  # authenticated operator
        for parent in lineage(context):
            publication_info = IWorkflowPublicationInfo(parent, None)
            if (publication_info is not None) and not publication_info.is_visible(request):
                raise NotFound()

    return FileView(request)
