#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.extfile.interfaces import EXTFILE_MANAGER_INFO_KEY, IExtFileManagerInfo
from pyams_content.root import ISiteRoot
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


@factory_config(IExtFileManagerInfo)
class ExtFileManagerInfo(Persistent):
    """external files manager settings"""

    default_title_prefix = FieldProperty(IExtFileManagerInfo['default_title_prefix'])


@adapter_config(context=ISiteRoot, provides=IExtFileManagerInfo)
def site_root_extfile_manager_info_factory(context):
    return get_annotation_adapter(context, EXTFILE_MANAGER_INFO_KEY, IExtFileManagerInfo)
