#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form.field import Fields
from zope.interface import implementer

from pyams_content import _
from pyams_content.component.calendar import ICalendarInfo, ICalendarTarget
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


@viewlet_config(name='calendar.menu',
                context=ICalendarTarget, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=20,
                permission=VIEW_SYSTEM_PERMISSION)
class CalendarMenu(MenuItem):
    """Calendar menu"""

    label = _("Calendar")
    icon_class = 'fa-calendar'
    url = '#calendar.html'


@pagelet_config(name='calendar.html',
                context=ICalendarTarget, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='calendar.json',
             context=ICalendarTarget, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class CalendarEditForm(AdminEditForm):
    """Calendar edit form"""

    legend = _("Calendar properties")

    fields = Fields(ICalendarInfo)
    ajax_handler = 'calendar.json'
