#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from datetime import date

import iso8601
from hypatia.interfaces import ICatalog
from hypatia.query import Ge, Le

from pyams_content.shared.view import ViewQuery
from pyams_content.shared.view.interfaces import IViewUserQuery
from pyams_utils.adapter import ContextAdapter, adapter_config
from pyams_utils.registry import get_utility

__docformat__ = 'restructuredtext'


@adapter_config(name='calendar',
                context=ViewQuery,
                provides=IViewUserQuery)
class ViewCalendarQueryParamsExtension(ContextAdapter):
    """View calendar query params extension"""

    @staticmethod
    def get_user_params(request):
        catalog = get_utility(ICatalog)
        from_date = request.params.get('from_date')
        if from_date:
            try:
                from_date = iso8601.parse_date(from_date)
            except iso8601.ParseError:
                from_date = None
            if not from_date:
                from_date = date.today()
            yield Ge(catalog['calendar_dates'], from_date)
            to_date = request.params.get('to_date')
            if to_date:
                try:
                    to_date = iso8601.parse_date(to_date)
                except iso8601.ParseError:
                    to_date = None
            if to_date:
                yield Le(catalog['calendar_dates'], to_date)
