#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_content.component.calendar module

"""

from z3c.form.interfaces import IWidget
from zope.interface import Interface
from zope.schema import Float

from pyams_content.component.calendar.schema import DatetimesField
from pyams_i18n.schema import I18nTextLineField

__docformat__ = 'restructuredtext'

from pyams_content import _


CALENDAR_INFORMATION_KEY = 'pyams_content.calendar'


class ICalendarInfo(Interface):
    """Calendar information interface"""

    location = I18nTextLineField(title=_("Event location"),
                                 description=_("Small label used to specify event location"),
                                 required=False)

    duration = Float(title=_("Duration"),
                     description=_("Default event duration, in hours"),
                     required=False)

    calendar = DatetimesField(title=_("Calendar details"),
                              description=_("List of dates and times on which the event is planned"),
                              required=False)


class ICalendarTarget(Interface):
    """Calendar target marker interface"""


class IDatetimesWidget(IWidget):
    """Datetimes widget interface"""
