#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from persistent import Persistent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.calendar.interfaces import CALENDAR_INFORMATION_KEY, ICalendarInfo, \
    ICalendarTarget
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'


@factory_config(ICalendarInfo)
class CalendarInfo(Persistent):
    """Calendar information interface"""

    location = FieldProperty(ICalendarInfo['location'])
    duration = FieldProperty(ICalendarInfo['duration'])
    calendar = FieldProperty(ICalendarInfo['calendar'])


@adapter_config(context=ICalendarTarget,
                provides=ICalendarInfo)
def calendar_info_factory(context):
    """Calendar information factory"""
    return get_annotation_adapter(context, CALENDAR_INFORMATION_KEY,
                                  ICalendarInfo)
